/* - StepperDetachListener -
 * Clear all the fields and disable all the controls
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.StepperPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.DetachListener;
import com.phidgets.event.DetachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class StepperDetachListener implements DetachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numMotorsTxt;
    private JTextField numInTxt;
    private JComboBox motorCmb;
    private JTextField velTxt;
    private JTextField accelTxt;
    private JTextField posTxt;
    private JTextField targetPosTxt;
    private JTextField torqueTxt;
    private JTextField currentTxt;
    private JSlider velScrl;
    private JSlider accelScrl;
    private JSlider targetPosScrl;
    private JSlider torqueScrl;
    private JCheckBox inputArray[];
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel16;
    private int targetPosArray[];
    
    /** Creates a new instance of StepperDetachListener */
    public StepperDetachListener(JFrame appFrame, JTextField attachedTxt,
            JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt,
            JTextField numMotorsTxt, JTextField numInTxt, JComboBox motorCmb,
            JTextField velTxt, JTextField accelTxt, JTextField posTxt,
            JTextField targetPosTxt, JTextField torqueTxt, JTextField currentTxt,
            JSlider velScrl, JSlider accelScrl, JSlider targetPosScrl,
            JSlider torqueScrl, JCheckBox inputArray[], JLabel jLabel11,
            JLabel jLabel12, JLabel jLabel16, int targetPosArray[])
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numMotorsTxt = numMotorsTxt;
        this.numInTxt = numInTxt;
        this.motorCmb = motorCmb;
        this.velTxt = velTxt;
        this.accelTxt = accelTxt;
        this.posTxt = posTxt;
        this.targetPosTxt = targetPosTxt;
        this.torqueTxt = torqueTxt;
        this.currentTxt = currentTxt;
        this.velScrl = velScrl;
        this.accelScrl = accelScrl;
        this.targetPosScrl = targetPosScrl;
        this.torqueScrl = torqueScrl;
        this.inputArray = inputArray;
        this.jLabel11 = jLabel11;
        this.jLabel12 = jLabel12;
        this.jLabel16 = jLabel16;
        this.targetPosArray = targetPosArray;
    }

    public void detached(DetachEvent de)
    {
        try
        {
            StepperPhidget detached = (StepperPhidget)de.getSource();
            attachedTxt.setText(Boolean.toString(detached.isAttached()));
            nameTxt.setText("");
            serialTxt.setText("");
            versionTxt.setText("");
            numMotorsTxt.setText("");
            numInTxt.setText("");
            
            motorCmb.setEnabled(false);
            motorCmb.removeAllItems();
            
            jLabel16.setVisible(false);
            torqueScrl.setEnabled(false);
            torqueScrl.setValue(0);
            torqueScrl.setVisible(false);

            jLabel11.setVisible(false);
            torqueTxt.setText("");
            torqueTxt.setVisible(false);

            jLabel12.setVisible(false);
            currentTxt.setText("");
            currentTxt.setVisible(false);
            
            velTxt.setText("");
            accelTxt.setText("");
            posTxt.setText("");
            targetPosTxt.setText("");
            
            velScrl.setEnabled(false);
            velScrl.setValue(0);
            accelScrl.setEnabled(false);
            accelScrl.setValue(0);
            targetPosScrl.setEnabled(false);
            targetPosScrl.setValue(0);
            
            int i;
            for(i = 0; i < 4; i++)
            {
                inputArray[i].setVisible(false);
            }
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
